import functools
import asyncio
from ccxt.base import errors as ccxt_errors
from shori.logger import get_logger

log = get_logger(__name__)


def handle_execution_loop_errors(func):
    @functools.wraps(func)
    async def wrapper(self, *args, **kwargs):
        func_name = f"{func.__module__}.{func.__name__}"
        while True:
            try:
                await func(self, *args, **kwargs)
            except (ccxt_errors.DDoSProtection, ccxt_errors.RateLimitExceeded):
                log.info("%s: RateLimit detected. Sleeping for 10 sec.", func_name)
                await asyncio.sleep(10)
            except ccxt_errors.NetworkError:
                log.info("%s: NetworkError detected. Sleeping for 10 sec.", func_name)
                await asyncio.sleep(10)
            except ccxt_errors.OperationFailed:
                log.info("%s: OperationFailed detected. Sleeping for 10 sec.", func_name)
                await asyncio.sleep(10)
            except asyncio.CancelledError:
                log.debug("%s: CancelledError raised, breaking out of loop", func_name)
                break

    return wrapper
