# Shori
```
███████╗██╗  ██╗ ██████╗ ██████╗ ██╗
██╔════╝██║  ██║██╔═══██╗██╔══██╗██║
███████╗███████║██║   ██║██████╔╝██║
╚════██║██╔══██║██║   ██║██╔══██╗██║
███████║██║  ██║╚██████╔╝██║  ██║██║
╚══════╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═╝╚═╝
```
Shori (処理) translates to "processing" or "handling." It generally refers to the act of managing, executing, or
dealing with tasks, data, or operations. This project is designed to facilitate the execution and management of
trading operations using asynchronous programming in Python.

## Features

- **Order Management System (OMS)**: Handles order creation, editing, and cancellation.
- **Live Order Book (LOB)**: Maintains a real-time view of the order book.
- **Trade Execution**: Executes trades and processes trade data.
- **Clearing System**: Manages order and trade data, ensuring consistency and accuracy.

## Installation

To install the necessary dependencies, run:
`make install`

## Usage

To use Shori, you can run the example project located in the `example` directory. This example demonstrates how to set
up a trading client and execute trades using the Shori framework.

Navigate to the `example` directory and run:

```bash
export PYTHONPATH=$(pwd)
uv run python example/teachme.py
```

This script will establish a connection to the exchange, subscribe to market data, and execute a trading strategy.

## Useful commands:

Activate venv: `make activate`

## Contributing

Contributions are welcome! Please fork the repository and submit a pull request for any improvements or bug fixes.
